#include <iostream>
#include <vector>
#include <unordered_map>

enum class BloodTypes
{
	BT_O = 0,
	BT_A = 1,
	BT_B = 2,
	BT_AB = 3
};

const std::unordered_map<std::string, BloodTypes> btmap = 
{
	{ "O", BloodTypes::BT_O },
	{ "A", BloodTypes::BT_A },
	{ "B", BloodTypes::BT_B },
	{ "AB", BloodTypes::BT_AB }
};

struct patient
{
	BloodTypes blood_type;
	int req_units;
	int recv_units[4];

	patient(std::string bt, int ru) : blood_type {btmap.at(bt)}, req_units {ru}, recv_units {0, 0, 0, 0} {}
};

inline void stop()
{
	std::cout << "nemoguce";
	exit(0);
}

int main()
{
	int n;
	int num_o, num_a, num_b, num_ab;

	std::vector<patient> patients;

	std::cin >> n;
	std::cin >> num_o >> num_a >> num_b >> num_ab;
	
	for(int i = 0; i < n; i++)
	{
		std::string bt;
		int ru;

		std::cin >> bt >> ru;

		patients.emplace_back(bt, ru);
	}

	for(auto &patient: patients)
	{
		while(patient.req_units > 0)
		{
			switch(patient.blood_type)
			{
				case BloodTypes::BT_O:
					if(num_o <= 0)
						stop();

					num_o--;
					patient.recv_units[0]++;		
					break;
				case BloodTypes::BT_A:
					if(num_a > 0)
					{
						num_a--;
						patient.recv_units[1]++;
						break;
					}
					if(num_o <= 0)
						stop();

					num_o--;
					patient.recv_units[0]++;
					break;
				case BloodTypes::BT_B:
					if(num_b > 0)
					{
						num_b--;
						patient.recv_units[2]++;
						break;
					}
					if(num_o <= 0)
						stop();

					num_o--;
					patient.recv_units[0]++;
					break;
				case BloodTypes::BT_AB:
					if(num_ab > 0)
					{
						num_ab--;
						patient.recv_units[3]++;
						break;
					}
					if(num_a > 0)
					{
						num_a--;
						patient.recv_units[1]++;
						break;
					}
					if(num_b > 0)
					{
						num_b--;
						patient.recv_units[2]++;
						break;
					}
					if(num_o <= 0)
						stop();

					num_o--;
					patient.recv_units[0]++;
					break;
			}
			patient.req_units--;
		}
	}

	std::cout << "moguce\n";

	for(const auto &patient : patients)
	{
		for(int i = 0; i < 4; i++)
			std::cout << patient.recv_units[i] << " ";

		std::cout << "\n";
	}

	return 0;
}